/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.GtfsTransformStrategy;
import org.onebusaway.gtfs_transformer.services.TransformContext;
import org.onebusaway.gtfs_transformer.updates.CalendarSimplicationLibrary;
import org.onebusaway.gtfs_transformer.updates.TripKey;

public class CalendarSimplicationStrategy
implements GtfsTransformStrategy {
    private static Pattern _mergedIdPattern = Pattern.compile("^(.*)_merged_(.*)$");
    private CalendarSimplicationLibrary _library = new CalendarSimplicationLibrary();
    private boolean _undoGoogleTransitDataFeedMergeTool = false;

    public void setMinNumberOfWeeksForCalendarEntry(int minNumberOfWeeksForCalendarEntry) {
        this._library.setMinNumberOfWeeksForCalendarEntry(minNumberOfWeeksForCalendarEntry);
    }

    public void setDayOfTheWeekInclusionRatio(double dayOfTheWeekInclusionRatio) {
        this._library.setDayOfTheWeekInclusionRatio(dayOfTheWeekInclusionRatio);
    }

    public void setUndoGoogleTransitDataFeedMergeTool(boolean undoGoogleTransitDataFeedMergeTool) {
        this._undoGoogleTransitDataFeedMergeTool = undoGoogleTransitDataFeedMergeTool;
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao) {
        RemoveEntityLibrary removeEntityLibrary = new RemoveEntityLibrary();
        CalendarServiceImpl calendarService = CalendarSimplicationLibrary.createCalendarService(dao);
        this._library.setCalendarService(calendarService);
        HashMap<Set<AgencyAndId>, AgencyAndId> serviceIdsToUpdatedServiceId = new HashMap<Set<AgencyAndId>, AgencyAndId>();
        Map<AgencyAndId, List<AgencyAndId>> mergeToolIdMapping = this.computeMergeToolIdMapping(dao);
        for (Route route : dao.getAllRoutes()) {
            Map<TripKey, List<Trip>> tripsByKey = TripKey.groupTripsForRouteByKey(dao, route);
            Map<Set<AgencyAndId>, List<TripKey>> tripKeysByServiceIds = this._library.groupTripKeysByServiceIds(tripsByKey);
            for (Set<AgencyAndId> serviceIds : tripKeysByServiceIds.keySet()) {
                AgencyAndId updatedServiceId = this.createUpdatedServiceId(serviceIdsToUpdatedServiceId, serviceIds);
                for (TripKey tripKey : tripKeysByServiceIds.get(serviceIds)) {
                    AgencyAndId updatedTripId;
                    List<Trip> tripsForKey = tripsByKey.get(tripKey);
                    Trip tripToKeep = tripsForKey.get(0);
                    tripToKeep.setServiceId(updatedServiceId);
                    for (int i = 1; i < tripsForKey.size(); ++i) {
                        Trip trip = tripsForKey.get(i);
                        removeEntityLibrary.removeTrip(dao, trip);
                    }
                    if (!this._undoGoogleTransitDataFeedMergeTool || (updatedTripId = this.computeUpdatedTripIdForMergedTripsIfApplicable(mergeToolIdMapping, tripsForKey)) == null) continue;
                    tripToKeep.setId(updatedTripId);
                }
            }
        }
        ArrayList<ServiceCalendar> allCalendarsToAdd = new ArrayList<ServiceCalendar>();
        ArrayList<ServiceCalendarDate> allCalendarDatesToAdd = new ArrayList<ServiceCalendarDate>();
        for (Map.Entry entry : serviceIdsToUpdatedServiceId.entrySet()) {
            Set serviceIds = (Set)entry.getKey();
            AgencyAndId updatedServiceId = (AgencyAndId)entry.getValue();
            ArrayList<ServiceCalendar> calendarsToAdd = new ArrayList<ServiceCalendar>();
            ArrayList<ServiceCalendarDate> calendarDatesToAdd = new ArrayList<ServiceCalendarDate>();
            this._library.computeSimplifiedCalendar(serviceIds, updatedServiceId, calendarsToAdd, calendarDatesToAdd);
            allCalendarsToAdd.addAll(calendarsToAdd);
            allCalendarDatesToAdd.addAll(calendarDatesToAdd);
        }
        this._library.saveUpdatedCalendarEntities(dao, allCalendarsToAdd, allCalendarDatesToAdd);
    }

    private AgencyAndId createUpdatedServiceId(Map<Set<AgencyAndId>, AgencyAndId> serviceIdsToUpdatedServiceId, Set<AgencyAndId> serviceIds) {
        AgencyAndId updatedServiceId = serviceIdsToUpdatedServiceId.get(serviceIds);
        if (updatedServiceId == null) {
            if (serviceIds.isEmpty()) {
                throw new IllegalStateException();
            }
            ArrayList<AgencyAndId> toSort = new ArrayList<AgencyAndId>(serviceIds);
            Collections.sort(toSort);
            StringBuilder b = new StringBuilder();
            String agencyId = null;
            for (int i = 0; i < toSort.size(); ++i) {
                AgencyAndId serviceId = (AgencyAndId)toSort.get(i);
                if (i == 0) {
                    agencyId = serviceId.getAgencyId();
                } else {
                    b.append("-");
                }
                b.append(serviceId.getId());
            }
            updatedServiceId = new AgencyAndId(agencyId, b.toString());
            serviceIdsToUpdatedServiceId.put(serviceIds, updatedServiceId);
        }
        return updatedServiceId;
    }

    private Map<AgencyAndId, List<AgencyAndId>> computeMergeToolIdMapping(GtfsDao dao) {
        if (!this._undoGoogleTransitDataFeedMergeTool) {
            return Collections.emptyMap();
        }
        FactoryMap<AgencyAndId, List<AgencyAndId>> mergedIdMapping = new FactoryMap<AgencyAndId, List<AgencyAndId>>(new ArrayList());
        FactoryMap unmergedIdMapping = new FactoryMap(new ArrayList());
        for (Trip trip : dao.getAllTrips()) {
            AgencyAndId tripId = trip.getId();
            AgencyAndId unmergedTripId = this.computeUnmergedTripId(tripId);
            if (unmergedTripId.equals(tripId)) {
                ((List)unmergedIdMapping.get(unmergedTripId)).add(tripId);
                continue;
            }
            ((List)mergedIdMapping.get(unmergedTripId)).add(tripId);
        }
        HashSet intersection = new HashSet(mergedIdMapping.keySet());
        intersection.retainAll(unmergedIdMapping.keySet());
        if (!intersection.isEmpty()) {
            throw new IllegalStateException("some ids appeared both in the merged and unmerged case: " + intersection);
        }
        mergedIdMapping.putAll(unmergedIdMapping);
        return mergedIdMapping;
    }

    private AgencyAndId computeUpdatedTripIdForMergedTripsIfApplicable(Map<AgencyAndId, List<AgencyAndId>> mergeToolIdMapping, List<Trip> trips) {
        AgencyAndId unmergedTripId = null;
        for (Trip trip : trips) {
            AgencyAndId id = this.computeUnmergedTripId(trip.getId());
            if (unmergedTripId == null) {
                unmergedTripId = id;
                continue;
            }
            if (unmergedTripId.equals(id)) continue;
            return null;
        }
        List<AgencyAndId> originalIds = mergeToolIdMapping.get(unmergedTripId);
        if (originalIds == null || originalIds.size() != trips.size()) {
            return null;
        }
        return unmergedTripId;
    }

    private AgencyAndId computeUnmergedTripId(AgencyAndId tripId) {
        Matcher m = _mergedIdPattern.matcher(tripId.getId());
        if (m.matches()) {
            return new AgencyAndId(tripId.getAgencyId(), m.group(1));
        }
        return tripId;
    }
}

