/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.updates;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.onebusaway.collections.Counter;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceDataFactoryImpl;
import org.onebusaway.gtfs.impl.calendar.CalendarServiceImpl;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.gtfs_transformer.updates.TripKey;
import org.onebusaway.gtfs_transformer.updates.UpdateLibrary;

public class CalendarSimplicationLibrary {
    private CalendarService _calendarService;
    private double _minNumberOfWeeksForCalendarEntry = 3.0;
    private double _dayOfTheWeekInclusionRatio = 0.5;

    public void setCalendarService(CalendarService calendarService) {
        this._calendarService = calendarService;
    }

    public void setMinNumberOfWeeksForCalendarEntry(int minNumberOfWeeksForCalendarEntry) {
        this._minNumberOfWeeksForCalendarEntry = minNumberOfWeeksForCalendarEntry;
    }

    public void setDayOfTheWeekInclusionRatio(double dayOfTheWeekInclusionRatio) {
        this._dayOfTheWeekInclusionRatio = dayOfTheWeekInclusionRatio;
    }

    public static CalendarServiceImpl createCalendarService(GtfsMutableRelationalDao dao) {
        CalendarServiceDataFactoryImpl factory = new CalendarServiceDataFactoryImpl();
        factory.setGtfsDao(dao);
        CalendarServiceImpl calendarService = new CalendarServiceImpl();
        calendarService.setDataFactory(factory);
        return calendarService;
    }

    public Map<Set<AgencyAndId>, List<TripKey>> groupTripKeysByServiceIds(Map<TripKey, List<Trip>> tripsByKey) {
        FactoryMap<Set<AgencyAndId>, List<TripKey>> tripKeysByServiceIds = new FactoryMap<Set<AgencyAndId>, List<TripKey>>(new ArrayList());
        for (Map.Entry<TripKey, List<Trip>> entry : tripsByKey.entrySet()) {
            TripKey key = entry.getKey();
            List<Trip> tripsForKey = entry.getValue();
            HashSet<AgencyAndId> serviceIds = new HashSet<AgencyAndId>();
            for (Trip trip : tripsForKey) {
                serviceIds.add(trip.getServiceId());
            }
            ((List)tripKeysByServiceIds.get(serviceIds)).add(key);
        }
        return tripKeysByServiceIds;
    }

    public void computeSimplifiedCalendar(Set<AgencyAndId> serviceIds, AgencyAndId updatedServiceId, List<ServiceCalendar> calendarsToAdd, List<ServiceCalendarDate> calendarDatesToAdd) {
        boolean useDateRange;
        Calendar c = Calendar.getInstance();
        TimeZone tz = TimeZone.getDefault();
        HashSet<ServiceDate> allServiceDates = new HashSet<ServiceDate>();
        for (AgencyAndId serviceId : serviceIds) {
            Set<ServiceDate> serviceDates = this._calendarService.getServiceDatesForServiceId(serviceId);
            allServiceDates.addAll(serviceDates);
        }
        if (allServiceDates.isEmpty()) {
            return;
        }
        ArrayList serviceDatesInOrder = new ArrayList(allServiceDates);
        Collections.sort(serviceDatesInOrder);
        Counter<Integer> daysOfTheWeekCounts = new Counter<Integer>();
        for (ServiceDate serviceDate : allServiceDates) {
            c.setTime(serviceDate.getAsDate());
            int dayOfTheWeek = c.get(7);
            daysOfTheWeekCounts.increment(dayOfTheWeek);
        }
        HashSet<Integer> daysOfTheWeekToUse = new HashSet<Integer>();
        Integer maxKey = (Integer)daysOfTheWeekCounts.getMax();
        int maxCount = daysOfTheWeekCounts.getCount(maxKey);
        for (Integer dayOfTheWeek : daysOfTheWeekCounts.getKeys()) {
            int count = daysOfTheWeekCounts.getCount(dayOfTheWeek);
            if ((double)count < (double)maxCount * this._dayOfTheWeekInclusionRatio) continue;
            daysOfTheWeekToUse.add(dayOfTheWeek);
        }
        ServiceDate fromDate = (ServiceDate)serviceDatesInOrder.get(0);
        ServiceDate toDate = (ServiceDate)serviceDatesInOrder.get(serviceDatesInOrder.size() - 1);
        boolean bl = useDateRange = (double)maxCount >= this._minNumberOfWeeksForCalendarEntry;
        if (useDateRange) {
            ServiceCalendar sc = this.createServiceCalendar(updatedServiceId, daysOfTheWeekToUse, fromDate, toDate);
            calendarsToAdd.add(sc);
        }
        ServiceDate serviceDate = fromDate;
        while (serviceDate.compareTo(toDate) <= 0) {
            boolean isActive = allServiceDates.contains(serviceDate);
            Calendar serviceDateAsCalendar = serviceDate.getAsCalendar(tz);
            if (useDateRange) {
                ServiceCalendarDate scd;
                int dayOfWeek = serviceDateAsCalendar.get(7);
                boolean dateRangeIncludesServiceDate = daysOfTheWeekToUse.contains(dayOfWeek);
                if (isActive && !dateRangeIncludesServiceDate) {
                    scd = new ServiceCalendarDate();
                    scd.setDate(serviceDate);
                    scd.setExceptionType(1);
                    scd.setServiceId(updatedServiceId);
                    calendarDatesToAdd.add(scd);
                }
                if (!isActive && dateRangeIncludesServiceDate) {
                    scd = new ServiceCalendarDate();
                    scd.setDate(serviceDate);
                    scd.setExceptionType(2);
                    scd.setServiceId(updatedServiceId);
                    calendarDatesToAdd.add(scd);
                }
            } else if (isActive) {
                ServiceCalendarDate scd = new ServiceCalendarDate();
                scd.setDate(serviceDate);
                scd.setExceptionType(1);
                scd.setServiceId(updatedServiceId);
                calendarDatesToAdd.add(scd);
            }
            serviceDate = serviceDate.next(tz);
        }
    }

    public void saveUpdatedCalendarEntities(GtfsMutableRelationalDao dao, List<ServiceCalendar> calendarsToAdd, List<ServiceCalendarDate> calendarDatesToAdd) {
        dao.clearAllEntitiesForType(ServiceCalendar.class);
        dao.clearAllEntitiesForType(ServiceCalendarDate.class);
        for (ServiceCalendar sc : calendarsToAdd) {
            dao.saveEntity(sc);
        }
        for (ServiceCalendarDate scd : calendarDatesToAdd) {
            dao.saveEntity(scd);
        }
        UpdateLibrary.clearDaoCache(dao);
    }

    private ServiceCalendar createServiceCalendar(AgencyAndId updatedServiceId, Set<Integer> daysOfTheWeekToUse, ServiceDate fromDate, ServiceDate toDate) {
        ServiceCalendar sc = new ServiceCalendar();
        sc.setServiceId(updatedServiceId);
        sc.setStartDate(fromDate);
        sc.setEndDate(toDate);
        if (daysOfTheWeekToUse.contains(2)) {
            sc.setMonday(1);
        }
        if (daysOfTheWeekToUse.contains(3)) {
            sc.setTuesday(1);
        }
        if (daysOfTheWeekToUse.contains(4)) {
            sc.setWednesday(1);
        }
        if (daysOfTheWeekToUse.contains(5)) {
            sc.setThursday(1);
        }
        if (daysOfTheWeekToUse.contains(6)) {
            sc.setFriday(1);
        }
        if (daysOfTheWeekToUse.contains(7)) {
            sc.setSaturday(1);
        }
        if (daysOfTheWeekToUse.contains(1)) {
            sc.setSunday(1);
        }
        return sc;
    }
}

