/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer.impl;

import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs_transformer.factory.PropertyMatches;
import org.onebusaway.gtfs_transformer.impl.AbstractEntityModificationStrategy;
import org.onebusaway.gtfs_transformer.impl.RemoveEntityLibrary;
import org.onebusaway.gtfs_transformer.services.TransformContext;

public class RemoveEntityUpdateStrategy
extends AbstractEntityModificationStrategy {
    private RemoveEntityLibrary _library = new RemoveEntityLibrary();

    public RemoveEntityUpdateStrategy(PropertyMatches propertyMatches) {
        super(propertyMatches);
    }

    @Override
    public void run(TransformContext context, GtfsMutableRelationalDao dao, BeanWrapper entity) {
        if (!this.isModificationApplicable(entity)) {
            return;
        }
        Object obj = entity.getWrappedInstance(Object.class);
        if (obj instanceof Agency) {
            this._library.removeAgency(dao, (Agency)obj);
        } else if (obj instanceof Route) {
            this._library.removeRoute(dao, (Route)obj);
        } else if (obj instanceof Stop) {
            this._library.removeStop(dao, (Stop)obj);
        } else if (obj instanceof Trip) {
            this._library.removeTrip(dao, (Trip)obj);
        } else if (obj instanceof StopTime) {
            this._library.removeStopTime(dao, (StopTime)obj);
        } else if (obj instanceof Frequency) {
            this._library.removeFrequency(dao, (Frequency)obj);
        } else {
            throw new IllegalStateException("attempt to remove entity of type " + entity.getClass());
        }
    }
}

