/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_transformer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.onebusaway.gtfs_transformer.GtfsTransformer;
import org.onebusaway.gtfs_transformer.GtfsTransformerLibrary;
import org.onebusaway.gtfs_transformer.updates.EnsureStopTimesIncreaseUpdateStrategy;
import org.onebusaway.gtfs_transformer.updates.LocalVsExpressUpdateStrategy;
import org.onebusaway.gtfs_transformer.updates.RemoveDuplicateTripsStrategy;
import org.onebusaway.gtfs_transformer.updates.RemoveRepeatedStopTimesStrategy;

public class GtfsTransformerMain {
    private static final String ARG_AGENCY_ID = "agencyId";
    private static final String ARG_MODIFICATIONS = "modifications";
    private static final String ARG_TRANSFORM = "transform";
    private static final String ARG_LOCAL_VS_EXPRESS = "localVsExpress";
    private static final String ARG_CHECK_STOP_TIMES = "checkStopTimes";
    private static final String ARG_REMOVE_REPEATED_STOP_TIMES = "removeRepeatedStopTimes";
    private static final String ARG_REMOVE_DUPLICATE_TRIPS = "removeDuplicateTrips";
    private static final String ARG_OVERWRITE_DUPLICATES = "overwriteDuplicates";
    private static CommandLineParser _parser = new PosixParser();
    private Options _options = new Options();

    public static void main(String[] args) throws IOException {
        GtfsTransformerMain m = new GtfsTransformerMain();
        m.run(args);
    }

    public GtfsTransformerMain() {
        this.buildOptions(this._options);
    }

    public void run(String[] args) throws IOException {
        if (this.needsHelp(args)) {
            this.printHelp();
            System.exit(0);
        }
        try {
            CommandLine cli = _parser.parse(this._options, args, true);
            this.runApplication(cli, args);
        }
        catch (MissingOptionException ex) {
            System.err.println("Missing argument: " + ex.getMessage());
            this.printHelp();
        }
        catch (MissingArgumentException ex) {
            System.err.println("Missing argument: " + ex.getMessage());
            this.printHelp();
        }
        catch (UnrecognizedOptionException ex) {
            System.err.println("Unknown argument: " + ex.getMessage());
            this.printHelp();
        }
        catch (AlreadySelectedException ex) {
            System.err.println("Argument already selected: " + ex.getMessage());
            this.printHelp();
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            this.printHelp();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void buildOptions(Options options) {
        options.addOption(ARG_AGENCY_ID, true, "agency id");
        options.addOption(ARG_MODIFICATIONS, true, "data modifications");
        options.addOption(ARG_TRANSFORM, true, "data transformation");
        options.addOption(ARG_LOCAL_VS_EXPRESS, false, "add additional local vs express fields");
        options.addOption(ARG_CHECK_STOP_TIMES, false, "check stop times are in order");
        options.addOption(ARG_REMOVE_REPEATED_STOP_TIMES, false, "remove repeated stop times");
        options.addOption(ARG_REMOVE_DUPLICATE_TRIPS, false, "remove duplicate trips");
        options.addOption(ARG_OVERWRITE_DUPLICATES, false, "overwrite duplicate elements");
    }

    protected void printHelp(PrintWriter out, Options options) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("usage.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            System.err.println(line);
        }
        reader.close();
    }

    protected void runApplication(CommandLine cli, String[] originalArgs) throws Exception {
        Option[] options;
        String[] args = cli.getArgs();
        if (args.length < 2) {
            this.printHelp();
            System.exit(-1);
        }
        ArrayList<File> paths = new ArrayList<File>();
        for (int i = 0; i < args.length - 1; ++i) {
            paths.add(new File(args[i]));
        }
        GtfsTransformer transformer = new GtfsTransformer();
        transformer.setGtfsInputDirectories(paths);
        transformer.setOutputDirectory(new File(args[args.length - 1]));
        for (Option option : options = this.getOptionsInCommandLineOrder(cli, originalArgs)) {
            String name = option.getOpt();
            if (name.equals(ARG_REMOVE_REPEATED_STOP_TIMES)) {
                this.configureRemoveRepeatedStopTimes(transformer);
            }
            if (name.equals(ARG_REMOVE_DUPLICATE_TRIPS)) {
                this.configureRemoveDuplicateTrips(transformer);
            }
            if (name.equals(ARG_CHECK_STOP_TIMES)) {
                this.configureEnsureStopTimesInOrder(transformer);
            }
            if (name.equals(ARG_AGENCY_ID)) {
                this.configureAgencyId(transformer, cli.getOptionValue(ARG_AGENCY_ID));
            }
            if (name.equals(ARG_MODIFICATIONS) || name.equals(ARG_TRANSFORM)) {
                GtfsTransformerLibrary.configureTransformation(transformer, option.getValue());
            }
            if (name.equals(ARG_LOCAL_VS_EXPRESS)) {
                this.configureLocalVsExpressUpdates(transformer);
            }
            if (!name.equals(ARG_OVERWRITE_DUPLICATES)) continue;
            transformer.getReader().setOverwriteDuplicates(true);
        }
        transformer.run();
    }

    private Option[] getOptionsInCommandLineOrder(CommandLine cli, String[] originalArgs) {
        Option[] options = cli.getOptions();
        ArrayList<Ordered<Option>> orderedOptions = new ArrayList<Ordered<Option>>();
        for (Option option : options) {
            String argName = option.getOpt();
            int optionPosition = originalArgs.length;
            for (int i = 0; i < originalArgs.length; ++i) {
                if (!originalArgs[i].endsWith(argName)) continue;
                optionPosition = i;
                break;
            }
            orderedOptions.add(new Ordered<Option>(option, optionPosition));
        }
        Collections.sort(orderedOptions);
        options = new Option[options.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = (Option)((Ordered)orderedOptions.get(i)).getObject();
        }
        return options;
    }

    private void configureRemoveRepeatedStopTimes(GtfsTransformer updater) {
        updater.addTransform(new RemoveRepeatedStopTimesStrategy());
    }

    private void configureRemoveDuplicateTrips(GtfsTransformer updater) {
        updater.addTransform(new RemoveDuplicateTripsStrategy());
    }

    private void configureAgencyId(GtfsTransformer updater, String agencyId) {
        if (agencyId != null) {
            updater.setAgencyId(agencyId);
        }
    }

    private void configureEnsureStopTimesInOrder(GtfsTransformer updater) {
        updater.addTransform(new EnsureStopTimesIncreaseUpdateStrategy());
    }

    private void configureLocalVsExpressUpdates(GtfsTransformer updater) {
        updater.addTransform(new LocalVsExpressUpdateStrategy());
    }

    protected void printHelp() throws IOException {
        this.printHelp(new PrintWriter(System.err, true), this._options);
    }

    private boolean needsHelp(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-h") && !arg.equals("--help") && !arg.equals("-help")) continue;
            return true;
        }
        return false;
    }

    private static class Ordered<T>
    implements Comparable<Ordered<T>> {
        private T _object;
        private int _order;

        public Ordered(T object, int order) {
            this._object = object;
            this._order = order;
        }

        public T getObject() {
            return this._object;
        }

        @Override
        public int compareTo(Ordered<T> o) {
            return this._order - o._order;
        }
    }
}

