/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.serialization.mappings;

import java.text.DecimalFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;
import org.onebusaway.gtfs.serialization.mappings.InvalidStopTimeException;

public class StopTimeFieldMappingFactory
implements FieldMappingFactory {
    private static DecimalFormat _format = new DecimalFormat("00");
    private static Pattern _pattern = Pattern.compile("^(\\d+):(\\d{2}):(\\d{2})$");

    @Override
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        return new StopTimeFieldMapping(entityType, csvFieldName, objFieldName, required);
    }

    public static String getSecondsAsString(int t) {
        int hours = t / 3600;
        int minutes = (t -= hours * 3600) / 60;
        int seconds = t -= minutes * 60;
        String value = _format.format(hours) + ":" + _format.format(minutes) + ":" + _format.format(seconds);
        return value;
    }

    public static int getStringAsSeconds(String value) {
        Matcher m = _pattern.matcher(value);
        if (!m.matches()) {
            throw new InvalidStopTimeException(value);
        }
        try {
            int hours = Integer.parseInt(m.group(1));
            int minutes = Integer.parseInt(m.group(2));
            int seconds = Integer.parseInt(m.group(3));
            return seconds + 60 * (minutes + 60 * hours);
        }
        catch (NumberFormatException ex) {
            throw new InvalidStopTimeException(value);
        }
    }

    private static class StopTimeFieldMapping
    extends AbstractFieldMapping
    implements Converter {
        public StopTimeFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
            super(entityType, csvFieldName, objFieldName, required);
        }

        @Override
        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            Object value = csvValues.get(this._csvFieldName);
            object.setPropertyValue(this._objFieldName, this.convert(Integer.TYPE, value));
        }

        @Override
        public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
            int t = (Integer)object.getPropertyValue(this._objFieldName);
            if (t < 0) {
                csvValues.put(this._csvFieldName, "");
                return;
            }
            String value = StopTimeFieldMappingFactory.getSecondsAsString(t);
            csvValues.put(this._csvFieldName, value);
        }

        @Override
        public Object convert(Class type, Object value) {
            if (type == Integer.class || type == Integer.TYPE) {
                String stringValue = value.toString();
                return StopTimeFieldMappingFactory.getStringAsSeconds(stringValue);
            }
            if (type == String.class) {
                return StopTimeFieldMappingFactory.getSecondsAsString((Integer)value);
            }
            throw new ConversionException("Could not convert " + value + " of type " + value.getClass() + " to " + type);
        }
    }
}

