/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.onebusaway.csv_entities.exceptions.MissingRequiredEntityException;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;

public class ExcludeOptionalAndMissingEntitySchemaFactory
implements EntitySchemaFactory {
    private final EntitySchemaFactory _source;
    private Map<Class<?>, EntitySchema> _schemas = new HashMap();

    public ExcludeOptionalAndMissingEntitySchemaFactory(EntitySchemaFactory source) {
        this._source = source;
    }

    public void scanEntities(Class<?> entityClass, Iterable<Object> entities) {
        EntitySchema schema = this._source.getSchema(entityClass);
        if (schema == null) {
            return;
        }
        schema = new EntitySchema(schema);
        List<FieldMapping> fields = schema.getFields();
        Iterator<FieldMapping> it = fields.iterator();
        while (it.hasNext()) {
            FieldMapping field = it.next();
            if (field.isAlwaysIncludeInOutput() || !this.allValuesAreMissingAndOptional(field, entities)) continue;
            it.remove();
        }
        this._schemas.put(entityClass, schema);
    }

    @Override
    public EntitySchema getSchema(Class<?> entityClass) {
        EntitySchema schema = this._schemas.get(entityClass);
        if (schema != null) {
            return schema;
        }
        return this._source.getSchema(entityClass);
    }

    private boolean allValuesAreMissingAndOptional(FieldMapping field, Iterable<Object> entities) {
        for (Object entity : entities) {
            BeanWrapper wrapped = BeanWrapperFactory.wrap(entity);
            try {
                if (field.isMissingAndOptional(wrapped)) continue;
                return false;
            }
            catch (MissingRequiredEntityException ex) {
                return false;
            }
        }
        return true;
    }
}

