/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.NoDefaultConverterException;
import org.onebusaway.csv_entities.schema.AbstractFieldMapping;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.DefaultConverter;

public class DefaultFieldMapping
extends AbstractFieldMapping {
    protected Class<?> _objFieldType;
    private Converter _converter;

    public DefaultFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        super(entityType, csvFieldName, objFieldName, required);
        this._objFieldType = objFieldType;
        this._converter = ConvertUtils.lookup(objFieldType);
        if (this._converter == null && objFieldType.equals(Object.class)) {
            this._converter = new DefaultConverter();
        }
    }

    @Override
    public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
        if (this.isMissingAndOptional(csvValues)) {
            return;
        }
        Object csvValue = csvValues.get(this._csvFieldName);
        if (this._converter == null) {
            throw new NoDefaultConverterException(this._entityType, this._csvFieldName, this._objFieldName, this._objFieldType);
        }
        Object objValue = this._converter.convert(this._objFieldType, csvValue);
        object.setPropertyValue(this._objFieldName, objValue);
    }

    @Override
    public void translateFromObjectToCSV(CsvEntityContext context, BeanWrapper object, Map<String, Object> csvValues) {
        if (this.isMissingAndOptional(object)) {
            return;
        }
        Object objValue = object.getPropertyValue(this._objFieldName);
        csvValues.put(this._csvFieldName, objValue);
    }
}

