/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.csv_entities.CSVListener;

public class CSVLibrary {
    private boolean _trimInitialWhitespace = false;

    public static String escapeValue(String value) {
        if (value.indexOf(44) != -1 || value.indexOf(34) != -1) {
            value = "\"" + value.replaceAll("\"", "\"\"") + "\"";
        }
        return value;
    }

    public static String getArrayAsCSV(double[] args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (double v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = false;
            }
            csv.append(v);
        }
        return csv.toString();
    }

    public static <T> String getArrayAsCSV(T[] args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (T v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public static <T> String getIterableAsCSV(Iterable<T> args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (T v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public static String getAsCSV(Object ... args) {
        StringBuilder csv = new StringBuilder();
        boolean seenFirst = false;
        for (Object v : args) {
            if (seenFirst) {
                csv.append(',');
            } else {
                seenFirst = true;
            }
            csv.append(CSVLibrary.escapeValue(v.toString()));
        }
        return csv.toString();
    }

    public void setTrimInitialWhitespace(boolean trimInitialWhitespace) {
        this._trimInitialWhitespace = trimInitialWhitespace;
    }

    public final void parse(InputStream is, CSVListener handler) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.parse(reader, handler);
    }

    public final void parse(File input, CSVListener handler) throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(input));
        this.parse(r, handler);
    }

    public void parse(BufferedReader r, CSVListener handler) throws IOException, Exception {
        String line = null;
        int lineNumber = 1;
        while ((line = r.readLine()) != null) {
            List<String> values = this.parse(line);
            try {
                handler.handleLine(values);
            }
            catch (Exception ex) {
                throw new Exception("error handling csv record for lineNumber=" + lineNumber, ex);
            }
            ++lineNumber;
        }
        r.close();
    }

    public final List<String> parse(String line) {
        EParseState resetState;
        StringBuilder token = new StringBuilder();
        ArrayList<StringBuilder> tokens = new ArrayList<StringBuilder>();
        if (line.length() > 0) {
            tokens.add(token);
        }
        EParseState state = resetState = this._trimInitialWhitespace ? EParseState.TRIM_INIT_WHITESPACE : EParseState.DATA;
        block22: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (state) {
                case TRIM_INIT_WHITESPACE: {
                    switch (c) {
                        case ' ': {
                            continue block22;
                        }
                        case '\"': {
                            if (token.length() == 0) {
                                state = EParseState.DATA_IN_QUOTES;
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case ',': {
                            token = new StringBuilder();
                            tokens.add(token);
                            continue block22;
                        }
                    }
                    state = EParseState.DATA;
                    token.append(c);
                    continue block22;
                }
                case DATA: {
                    switch (c) {
                        case '\"': {
                            if (token.length() == 0) {
                                state = EParseState.DATA_IN_QUOTES;
                                continue block22;
                            }
                            token.append(c);
                            continue block22;
                        }
                        case ',': {
                            token = new StringBuilder();
                            tokens.add(token);
                            state = resetState;
                            continue block22;
                        }
                    }
                    token.append(c);
                    continue block22;
                }
                case DATA_IN_QUOTES: {
                    switch (c) {
                        case '\"': {
                            state = EParseState.END_QUOTE;
                            continue block22;
                        }
                    }
                    token.append(c);
                    continue block22;
                }
                case END_QUOTE: {
                    switch (c) {
                        case '\"': {
                            token.append('\"');
                            state = EParseState.DATA_IN_QUOTES;
                            continue block22;
                        }
                        case ',': {
                            token = new StringBuilder();
                            tokens.add(token);
                            state = resetState;
                            continue block22;
                        }
                    }
                    token.append(c);
                    state = EParseState.DATA;
                }
            }
        }
        ArrayList<String> retro = new ArrayList<String>(tokens.size());
        for (StringBuilder b : tokens) {
            retro.add(b.toString());
        }
        return retro;
    }

    private static enum EParseState {
        TRIM_INIT_WHITESPACE,
        DATA,
        DATA_IN_QUOTES,
        END_QUOTE;

    }
}

