/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.tuple;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.onebusaway.collections.tuple.Pair;
import org.onebusaway.collections.tuple.Tuples;

final class PairImpl<T>
implements Pair<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final T _first;
    private final T _second;

    public PairImpl(T first, T second) {
        this._first = first;
        this._second = second;
    }

    @Override
    public T getFirst() {
        return this._first;
    }

    @Override
    public T getSecond() {
        return this._second;
    }

    @Override
    public boolean isReflexive() {
        return Tuples.equals(this._first, this._second);
    }

    @Override
    public boolean contains(T element) {
        return Tuples.equals(this._first, element) || Tuples.equals(this._second, element);
    }

    @Override
    public T getOpposite(T element) {
        if (Tuples.equals(this._first, element)) {
            return this._second;
        }
        if (Tuples.equals(this._second, element)) {
            return this._first;
        }
        throw new NoSuchElementException();
    }

    @Override
    public PairImpl<T> swap() {
        return new PairImpl<T>(this._second, this._first);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._first == null ? 0 : this._first.hashCode());
        result = 31 * result + (this._second == null ? 0 : this._second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PairImpl other = (PairImpl)obj;
        return Tuples.equals(this._first, other._first) && Tuples.equals(this._second, other._second);
    }

    public String toString() {
        return "Pair(" + this._first + "," + this._second + ")";
    }
}

