/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections;

import java.lang.reflect.Method;

public final class PropertyPathExpression {
    private String[] _properties;
    private transient Method[] _methods = null;

    public static Object evaluate(Object target, String query) {
        return new PropertyPathExpression(query).invoke(target);
    }

    public PropertyPathExpression(String query) {
        this._properties = query.split("\\.");
    }

    public String getPath() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this._properties.length; ++i) {
            if (i > 0) {
                b.append('.');
            }
            b.append(this._properties[i]);
        }
        return b.toString();
    }

    public Class<?> initialize(Class<?> sourceValueType) {
        if (this._methods != null) {
            if (this._methods.length == 0) {
                return sourceValueType;
            }
            return this._methods[this._methods.length - 1].getReturnType();
        }
        this._methods = new Method[this._properties.length];
        for (int i = 0; i < this._properties.length; ++i) {
            Method m = null;
            String name = this._properties[i];
            String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            try {
                m = sourceValueType.getMethod(methodName, new Class[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("error introspecting class: " + sourceValueType, ex);
            }
            if (m == null) {
                throw new IllegalStateException("could not find property: " + this._properties[i]);
            }
            m.setAccessible(true);
            this._methods[i] = m;
            sourceValueType = m.getReturnType();
        }
        return sourceValueType;
    }

    public Class<?> getParentType(Class<?> sourceValueType) {
        this.initialize(sourceValueType);
        if (this._methods.length < 2) {
            return sourceValueType;
        }
        return this._methods[this._methods.length - 2].getReturnType();
    }

    public String getLastProperty() {
        return this._properties[this._properties.length - 1];
    }

    public Object invoke(Object value) {
        if (this._methods == null) {
            this.initialize(value.getClass());
        }
        for (int i = 0; i < this._properties.length; ++i) {
            Method m = this._methods[i];
            try {
                value = m.invoke(value, new Object[0]);
                continue;
            }
            catch (Exception ex) {
                throw new IllegalStateException("error invoking property reader: obj=" + value + " property=" + this._properties[i], ex);
            }
        }
        return value;
    }
}

