/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections;

import java.util.ArrayList;
import java.util.List;
import org.onebusaway.collections.PropertyPathExpression;

public final class FunctionalLibrary {
    private FunctionalLibrary() {
    }

    public static <T> List<T> filter(Iterable<T> elements, String propertyPathExpression, Object value) {
        ArrayList<T> matches = new ArrayList<T>();
        PropertyPathExpression query = new PropertyPathExpression(propertyPathExpression);
        for (T element : elements) {
            Object result = query.invoke(element);
            if ((value != null || result != null) && (value == null || !value.equals(result))) continue;
            matches.add(element);
        }
        return matches;
    }

    public static <T> T filterFirst(Iterable<T> elements, String propertyPathExpression, Object value) {
        List<T> matches = FunctionalLibrary.filter(elements, propertyPathExpression, value);
        return matches.isEmpty() ? null : (T)matches.get(0);
    }
}

