/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies.scoring;

import java.util.HashSet;
import java.util.Set;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;

public class TripStopsInCommonDuplicateScoringStrategy
implements DuplicateScoringStrategy<Trip> {
    @Override
    public double score(GtfsMergeContext context, Trip source, Trip target) {
        Set<Stop> sourceStops = this.getStopsForTrip(context.getSource(), source);
        Set<Stop> targetStops = this.getStopsForTrip(context.getTarget(), target);
        return DuplicateScoringSupport.scoreElementOverlap(sourceStops, targetStops);
    }

    private Set<Stop> getStopsForTrip(GtfsRelationalDao dao, Trip trip) {
        HashSet<Stop> stops = new HashSet<Stop>();
        for (StopTime stopTime : dao.getStopTimesForTrip(trip)) {
            stops.add(stopTime.getStop());
        }
        return stops;
    }
}

