/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies.scoring;

import java.util.HashSet;
import java.util.Set;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;

public class RouteStopsInCommonDuplicateScoringStrategy
implements DuplicateScoringStrategy<Route> {
    @Override
    public double score(GtfsMergeContext context, Route source, Route target) {
        Set<Stop> sourceStops = this.getAllStopsForRoute(context.getSource(), source);
        Set<Stop> targetStops = this.getAllStopsForRoute(context.getTarget(), target);
        return DuplicateScoringSupport.scoreElementOverlap(sourceStops, targetStops);
    }

    private Set<Stop> getAllStopsForRoute(GtfsRelationalDao dao, Route route) {
        HashSet<Stop> stops = new HashSet<Stop>();
        for (Trip trip : dao.getTripsForRoute(route)) {
            for (StopTime stopTime : dao.getStopTimesForTrip(trip)) {
                stops.add(stopTime.getStop());
            }
        }
        return stops;
    }
}

