/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import java.util.Collection;
import java.util.List;
import org.onebusaway.gtfs.model.Frequency;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractIdentifiableSingleEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.TripScheduleOverlapDuplicateScoringStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.TripStopsInCommonDuplicateScoringStrategy;

public class TripMergeStrategy
extends AbstractIdentifiableSingleEntityMergeStrategy<Trip> {
    public TripMergeStrategy() {
        super(Trip.class);
        this._duplicateScoringStrategy.addPropertyMatch("route");
        this._duplicateScoringStrategy.addPropertyMatch("serviceId");
        this._duplicateScoringStrategy.addStrategy(new TripStopsInCommonDuplicateScoringStrategy());
        this._duplicateScoringStrategy.addStrategy(new TripScheduleOverlapDuplicateScoringStrategy());
    }

    @Override
    public void getEntityTypes(Collection<Class<?>> entityTypes) {
        super.getEntityTypes(entityTypes);
        entityTypes.add(StopTime.class);
    }

    @Override
    protected boolean rejectDuplicateOverDifferences(GtfsMergeContext context, Trip sourceEntity, Trip targetDuplicate) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        List<StopTime> sourceStopTimes = source.getStopTimesForTrip(sourceEntity);
        List<StopTime> targetStopTimes = target.getStopTimesForTrip(targetDuplicate);
        if (sourceStopTimes.size() != targetStopTimes.size()) {
            return true;
        }
        for (int i = 0; i < sourceStopTimes.size(); ++i) {
            StopTime sourceStopTime = sourceStopTimes.get(i);
            StopTime targetStopTime = targetStopTimes.get(i);
            if (sourceStopTime.getStop().equals(targetStopTime.getStop())) {
                return true;
            }
            if (sourceStopTime.getArrivalTime() == targetStopTime.getArrivalTime() && sourceStopTime.getDepartureTime() == targetStopTime.getDepartureTime()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void replaceDuplicateEntry(GtfsMergeContext context, Trip oldTrip, Trip newTrip) {
        GtfsRelationalDao source = context.getSource();
        for (StopTime stopTime : source.getStopTimesForTrip(oldTrip)) {
            stopTime.setTrip(newTrip);
        }
        for (Frequency frequency : source.getFrequenciesForTrip(oldTrip)) {
            frequency.setTrip(newTrip);
        }
    }

    @Override
    protected void save(GtfsMergeContext context, IdentityBean<?> entity) {
        super.save(context, entity);
        Trip trip = (Trip)entity;
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        for (StopTime stopTime : source.getStopTimesForTrip(trip)) {
            stopTime.setId(0);
            target.saveEntity(stopTime);
        }
    }
}

