/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractIdentifiableSingleEntityMergeStrategy;

public class AgencyMergeStrategy
extends AbstractIdentifiableSingleEntityMergeStrategy<Agency> {
    public AgencyMergeStrategy() {
        super(Agency.class);
        this._duplicateScoringStrategy.addPropertyMatch("name");
        this._duplicateScoringStrategy.addPropertyMatch("url");
    }

    @Override
    protected void replaceDuplicateEntry(GtfsMergeContext context, Agency oldAgency, Agency newAgency) {
        GtfsRelationalDao source = context.getSource();
        for (Route route : source.getRoutesForAgency(oldAgency)) {
            route.setAgency(newAgency);
        }
        if (!oldAgency.getId().equals(newAgency.getId())) {
            this.renameAgencyId(source, oldAgency.getId(), newAgency.getId());
        }
    }

    @Override
    protected void rename(GtfsMergeContext context, IdentityBean<?> entity) {
        GtfsRelationalDao source = context.getSource();
        String prefix = context.getPrefix();
        Agency agency = (Agency)entity;
        String oldAgencyId = agency.getId();
        String newAgencyId = prefix + oldAgencyId;
        agency.setId(newAgencyId);
        this.renameAgencyId(source, oldAgencyId, newAgencyId);
    }

    private void renameAgencyId(GtfsRelationalDao source, String oldAgencyId, String newAgencyId) {
        this.bulkRenameAgencyId(source.getAllStops(), oldAgencyId, newAgencyId);
        this.bulkRenameAgencyId(source.getAllRoutes(), oldAgencyId, newAgencyId);
        this.bulkRenameAgencyId(source.getAllTrips(), oldAgencyId, newAgencyId);
        this.bulkRenameAgencyId(source.getAllFareAttributes(), oldAgencyId, newAgencyId);
        this.bulkRenameAgencyId(source.getAllPathways(), oldAgencyId, newAgencyId);
        this.bulkRenameAgencyIdInProperties(source.getAllTrips(), oldAgencyId, newAgencyId, "serviceId", "shapeId");
        this.bulkRenameAgencyIdInProperties(source.getAllCalendars(), oldAgencyId, newAgencyId, "serviceId");
        this.bulkRenameAgencyIdInProperties(source.getAllCalendarDates(), oldAgencyId, newAgencyId, "serviceId");
        this.bulkRenameAgencyIdInProperties(source.getAllShapePoints(), oldAgencyId, newAgencyId, "shapeId");
    }

    private <T extends IdentityBean<AgencyAndId>> void bulkRenameAgencyId(Iterable<T> elements, String oldAgencyId, String newAgencyId) {
        for (IdentityBean element : elements) {
            AgencyAndId id = (AgencyAndId)element.getId();
            if (!id.getAgencyId().equals(oldAgencyId)) continue;
            AgencyAndId newId = new AgencyAndId(newAgencyId, id.getId());
            element.setId(newId);
        }
    }

    private <T> void bulkRenameAgencyIdInProperties(Iterable<T> elements, String oldAgencyId, String newAgencyId, String ... properties) {
        for (T element : elements) {
            BeanWrapper wrapped = BeanWrapperFactory.wrap(element);
            for (String property : properties) {
                AgencyAndId id = (AgencyAndId)wrapped.getPropertyValue(property);
                if (id == null || !id.getAgencyId().equals(oldAgencyId)) continue;
                AgencyAndId updatedId = new AgencyAndId(newAgencyId, id.getId());
                wrapped.setPropertyValue(property, updatedId);
            }
        }
    }
}

