/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.collections.Max;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractSingleEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.EDuplicateDetectionStrategy;
import org.onebusaway.gtfs_merge.strategies.MergeSupport;
import org.onebusaway.gtfs_merge.strategies.scoring.AndDuplicateScoringStrategy;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;

public abstract class AbstractIdentifiableSingleEntityMergeStrategy<T extends IdentityBean<?>>
extends AbstractSingleEntityMergeStrategy<T> {
    protected AndDuplicateScoringStrategy<T> _duplicateScoringStrategy = new AndDuplicateScoringStrategy();

    public AbstractIdentifiableSingleEntityMergeStrategy(Class<T> entityType) {
        super(entityType);
    }

    @Override
    protected EDuplicateDetectionStrategy pickBestDuplicateDetectionStrategy(GtfsMergeContext context) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        if (target.getAllEntitiesForType(this._entityType).isEmpty() || source.getAllEntitiesForType(this._entityType).isEmpty()) {
            return EDuplicateDetectionStrategy.NONE;
        }
        if (this.hasLikelyIdentifierOverlap(context)) {
            return EDuplicateDetectionStrategy.IDENTITY;
        }
        if (this.hasLikelyFuzzyOverlap(context)) {
            return EDuplicateDetectionStrategy.FUZZY;
        }
        return EDuplicateDetectionStrategy.NONE;
    }

    private boolean hasLikelyIdentifierOverlap(GtfsMergeContext context) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        Collection targetEntities = target.getAllEntitiesForType(this._entityType);
        Collection sourceEntities = source.getAllEntitiesForType(this._entityType);
        Map sourceById = MappingLibrary.mapToValue(targetEntities, "id");
        Map targetById = MappingLibrary.mapToValue(sourceEntities, "id");
        HashSet commonIds = new HashSet();
        double elementOvelapScore = DuplicateScoringSupport.scoreElementOverlap(sourceById.keySet(), targetById.keySet(), commonIds);
        if (commonIds.isEmpty() || elementOvelapScore < this._minElementsInCommonScoreForAutoDetect) {
            return false;
        }
        double totalScore = 0.0;
        for (Serializable id : commonIds) {
            IdentityBean targetEntity = (IdentityBean)sourceById.get(id);
            IdentityBean sourceEntity = (IdentityBean)targetById.get(id);
            totalScore += this._duplicateScoringStrategy.score(context, sourceEntity, targetEntity);
        }
        return (totalScore /= (double)commonIds.size()) > this._minElementsDuplicateScoreForAutoDetect;
    }

    private boolean hasLikelyFuzzyOverlap(GtfsMergeContext context) {
        GtfsRelationalDao source = context.getSource();
        GtfsMutableRelationalDao target = context.getTarget();
        Collection targetEntities = target.getAllEntitiesForType(this._entityType);
        Collection sourceEntities = source.getAllEntitiesForType(this._entityType);
        double duplicateElements = 0.0;
        double totalScore = 0.0;
        HashSet remainingSourceEntities = new HashSet(sourceEntities);
        for (IdentityBean targetEntity : targetEntities) {
            Max<IdentityBean> best = new Max<IdentityBean>();
            for (IdentityBean sourceEntity : remainingSourceEntities) {
                double score = this._duplicateScoringStrategy.score(context, sourceEntity, targetEntity);
                if (score < this._minElementDuplicateScoreForFuzzyMatch) continue;
                best.add(score, sourceEntity);
            }
            if (best.getMaxElement() == null) continue;
            duplicateElements += 1.0;
            totalScore += best.getMaxValue();
            remainingSourceEntities.remove(best.getMaxElement());
        }
        double elementsInCommon = (duplicateElements / (double)targetEntities.size() + duplicateElements / (double)sourceEntities.size()) / 2.0;
        if (elementsInCommon < this._minElementsInCommonScoreForAutoDetect) {
            return false;
        }
        return (totalScore /= duplicateElements) > this._minElementsDuplicateScoreForAutoDetect;
    }

    @Override
    protected IdentityBean<?> getIdentityDuplicate(GtfsMergeContext context, IdentityBean<?> entity) {
        String rawId = this.getRawId(entity.getId());
        return (IdentityBean)context.getEntityForRawId(rawId);
    }

    @Override
    protected IdentityBean<?> getFuzzyDuplicate(GtfsMergeContext context, IdentityBean<?> entity) {
        GtfsMutableRelationalDao targetDao = context.getTarget();
        Collection targets = targetDao.getAllEntitiesForType(this._entityType);
        if (targets.isEmpty()) {
            return null;
        }
        Max<IdentityBean> best = new Max<IdentityBean>();
        for (IdentityBean target : targets) {
            String targetRawId = this.getRawId(target.getId());
            if (context.isEntityJustAddedWithRawId(targetRawId)) continue;
            double score = this._duplicateScoringStrategy.score(context, entity, target);
            best.add(score, target);
        }
        if (best.getMaxValue() < this._minElementsDuplicateScoreForAutoDetect) {
            return null;
        }
        return (IdentityBean)best.getMaxElement();
    }

    @Override
    protected void save(GtfsMergeContext context, IdentityBean<?> entity) {
        String rawId = this.getRawId(entity.getId());
        if (context.getEntityForRawId(rawId) != null) {
            this.rename(context, entity);
            rawId = this.getRawId(entity.getId());
        }
        context.putEntityWithRawId(rawId, entity);
        super.save(context, entity);
    }

    private String getRawId(Object id) {
        if (id instanceof String) {
            return (String)id;
        }
        if (id instanceof AgencyAndId) {
            return ((AgencyAndId)id).getId();
        }
        throw new UnsupportedOperationException("cannot generate raw key for type: " + id.getClass());
    }

    protected void rename(GtfsMergeContext context, IdentityBean<?> entity) {
        Object id = entity.getId();
        if (id != null && id instanceof AgencyAndId) {
            IdentityBean<?> bean = entity;
            AgencyAndId agencyAndId = (AgencyAndId)bean.getId();
            agencyAndId = MergeSupport.renameAgencyAndId(context, agencyAndId);
            bean.setId(agencyAndId);
        }
    }
}

