/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge.strategies;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.onebusaway.csv_entities.exceptions.CsvException;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AbstractEntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.EDuplicateDetectionStrategy;
import org.onebusaway.gtfs_merge.strategies.MergeSupport;
import org.onebusaway.gtfs_merge.strategies.scoring.DuplicateScoringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectionEntityMergeStrategy<KEY extends Serializable>
extends AbstractEntityMergeStrategy {
    private static final Logger _log = LoggerFactory.getLogger(AbstractCollectionEntityMergeStrategy.class);
    private final String _keyDescription;

    public AbstractCollectionEntityMergeStrategy(String keyDescription) {
        this._keyDescription = keyDescription;
    }

    @Override
    public void merge(GtfsMergeContext context) {
        for (Serializable key : this.getKeys(context.getSource())) {
            this.processKey(context, key);
        }
    }

    private void processKey(GtfsMergeContext context, KEY key) {
        KEY duplicate = this.getDuplicate(context, key);
        if (duplicate != null) {
            this.logDuplicateKey(key);
            if (!duplicate.equals(key)) {
                this.renameKey(context, key, duplicate);
            }
            return;
        }
        String rawKey = this.getRawKey(key);
        if (context.getEntityForRawId(rawKey) != null) {
            KEY newKey = this.getRenamedKey(context, key);
            this.renameKey(context, key, newKey);
            key = newKey;
            rawKey = this.getRawKey(key);
            MergeSupport.clearCaches(context.getSource());
        }
        context.putEntityWithRawId(rawKey, key);
        this.saveElementsForKey(context, key);
    }

    protected abstract Collection<KEY> getKeys(GtfsRelationalDao var1);

    private KEY getDuplicate(GtfsMergeContext context, KEY key) {
        EDuplicateDetectionStrategy duplicateDetectionStrategy = this.determineDuplicateDetectionStrategy(context);
        switch (duplicateDetectionStrategy) {
            case IDENTITY: {
                return this.getIdentityDuplicate(context, key);
            }
            case FUZZY: {
                return this.getFuzzyDuplicate(context, key);
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("unknown duplicate detection strategy: " + (Object)((Object)this._duplicateDetectionStrategy));
    }

    @Override
    protected EDuplicateDetectionStrategy pickBestDuplicateDetectionStrategy(GtfsMergeContext context) {
        Collection<KEY> targetKeys = this.getKeys(context.getTarget());
        Collection<KEY> sourceKeys = this.getKeys(context.getSource());
        if (targetKeys.isEmpty() || sourceKeys.isEmpty()) {
            return EDuplicateDetectionStrategy.NONE;
        }
        if (this.hasLikelyIdentifierOverlap(context, sourceKeys, targetKeys)) {
            return EDuplicateDetectionStrategy.IDENTITY;
        }
        if (this.hasLikelyFuzzyOverlap(context, sourceKeys, targetKeys)) {
            return EDuplicateDetectionStrategy.FUZZY;
        }
        return EDuplicateDetectionStrategy.NONE;
    }

    private boolean hasLikelyIdentifierOverlap(GtfsMergeContext context, Collection<KEY> sourceKeys, Collection<KEY> targetKeys) {
        HashSet commonKeys = new HashSet();
        double elementOvelapScore = DuplicateScoringSupport.scoreElementOverlap(sourceKeys, targetKeys, commonKeys);
        if (commonKeys.isEmpty() || elementOvelapScore < this._minElementsInCommonScoreForAutoDetect) {
            return false;
        }
        double totalScore = 0.0;
        for (Serializable key : commonKeys) {
            totalScore += this.scoreDuplicateKey(context, key);
        }
        return (totalScore /= (double)commonKeys.size()) > this._minElementsDuplicateScoreForAutoDetect;
    }

    protected abstract double scoreDuplicateKey(GtfsMergeContext var1, KEY var2);

    private boolean hasLikelyFuzzyOverlap(GtfsMergeContext context, Collection<KEY> sourceKeys, Collection<KEY> targetKeys) {
        return false;
    }

    private KEY getIdentityDuplicate(GtfsMergeContext context, KEY key) {
        String rawKey = this.getRawKey(key);
        return (KEY)((Serializable)context.getEntityForRawId(rawKey));
    }

    private KEY getFuzzyDuplicate(GtfsMergeContext context, KEY key) {
        return null;
    }

    protected String getRawKey(KEY key) {
        if (key instanceof AgencyAndId) {
            return ((AgencyAndId)key).getId();
        }
        throw new UnsupportedOperationException("cannot generate raw key for type: " + key.getClass());
    }

    private void logDuplicateKey(KEY key) {
        switch (this._logDuplicatesStrategy) {
            case NONE: {
                break;
            }
            case WARNING: {
                _log.warn("duplicate key: type=" + this._keyDescription + " key=" + key);
                break;
            }
            case ERROR: {
                throw new CsvException("duplicate key: type=" + this._keyDescription + " key=" + key);
            }
        }
    }

    protected abstract void renameKey(GtfsMergeContext var1, KEY var2, KEY var3);

    protected abstract void saveElementsForKey(GtfsMergeContext var1, KEY var2);

    private KEY getRenamedKey(GtfsMergeContext context, KEY key) {
        if (key instanceof String) {
            return (KEY)(context.getPrefix() + key);
        }
        if (key instanceof AgencyAndId) {
            return (KEY)MergeSupport.renameAgencyAndId(context, (AgencyAndId)key);
        }
        throw new UnsupportedOperationException("uknown key type: " + key.getClass());
    }

    @Override
    protected String getDescription() {
        return this._keyDescription;
    }
}

