/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs_merge;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.serialization.GtfsWriter;
import org.onebusaway.gtfs_merge.GtfsMergeContext;
import org.onebusaway.gtfs_merge.strategies.AgencyMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.EntityMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.FareAttributeMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.FareRuleMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.FrequencyMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.RouteMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.ServiceCalendarMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.ShapePointMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.StopMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.TransferMergeStrategy;
import org.onebusaway.gtfs_merge.strategies.TripMergeStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsMerger {
    private static Logger _log = LoggerFactory.getLogger(GtfsMerger.class);
    private static final String _alphaPrefix = "abcdefghijklmnopqrstuvwxyz";
    private static final NumberFormat _numberPrefixFormat = new DecimalFormat("00");
    private EntityMergeStrategy _agencyStrategy = new AgencyMergeStrategy();
    private EntityMergeStrategy _stopStrategy = new StopMergeStrategy();
    private EntityMergeStrategy _serviceCalendarStrategy = new ServiceCalendarMergeStrategy();
    private EntityMergeStrategy _routeStrategy = new RouteMergeStrategy();
    private EntityMergeStrategy _tripStrategy = new TripMergeStrategy();
    private EntityMergeStrategy _shapePointStrategy = new ShapePointMergeStrategy();
    private EntityMergeStrategy _frequencyStrategy = new FrequencyMergeStrategy();
    private EntityMergeStrategy _transferStrategy = new TransferMergeStrategy();
    private EntityMergeStrategy _fareAttributeStrategy = new FareAttributeMergeStrategy();
    private EntityMergeStrategy _fareRuleStrategy = new FareRuleMergeStrategy();

    public void setAgencyStrategy(EntityMergeStrategy agencyStrategy) {
        this._agencyStrategy = agencyStrategy;
    }

    public void setStopStrategy(EntityMergeStrategy stopsStrategy) {
        this._stopStrategy = stopsStrategy;
    }

    public void setServiceCalendarStrategy(EntityMergeStrategy serviceCalendarStrategy) {
        this._serviceCalendarStrategy = serviceCalendarStrategy;
    }

    public void setRouteStrategy(EntityMergeStrategy routeStrategy) {
        this._routeStrategy = routeStrategy;
    }

    public void setTripStrategy(EntityMergeStrategy tripStrategy) {
        this._tripStrategy = tripStrategy;
    }

    public void setShapePointStrategy(EntityMergeStrategy shapePointStrategy) {
        this._shapePointStrategy = shapePointStrategy;
    }

    public void setFrequencyStrategy(EntityMergeStrategy frequencyStrategy) {
        this._frequencyStrategy = frequencyStrategy;
    }

    public void setTransferStrategy(EntityMergeStrategy transferStrategy) {
        this._transferStrategy = transferStrategy;
    }

    public void setFareAttributeStrategy(EntityMergeStrategy fareAttributeStrategy) {
        this._fareAttributeStrategy = fareAttributeStrategy;
    }

    public void setFareRuleStrategy(EntityMergeStrategy fareRuleStrategy) {
        this._fareRuleStrategy = fareRuleStrategy;
    }

    public EntityMergeStrategy getEntityMergeStrategyForEntityType(Class<?> entityType) {
        ArrayList<EntityMergeStrategy> strategies = new ArrayList<EntityMergeStrategy>();
        this.buildStrategies(strategies);
        for (EntityMergeStrategy strategy : strategies) {
            HashSet entityTypes = new HashSet();
            strategy.getEntityTypes(entityTypes);
            if (!entityTypes.contains(entityType)) continue;
            return strategy;
        }
        return null;
    }

    public void run(List<File> inputPaths, File outputPath) throws IOException {
        GtfsRelationalDaoImpl mergedDao = new GtfsRelationalDaoImpl();
        mergedDao.setPackShapePoints(true);
        mergedDao.setPackStopTimes(true);
        ArrayList<EntityMergeStrategy> strategies = new ArrayList<EntityMergeStrategy>();
        this.buildStrategies(strategies);
        HashMap rawEntityIdMapsByMergeStrategy = new HashMap();
        for (EntityMergeStrategy strategy : strategies) {
            rawEntityIdMapsByMergeStrategy.put(strategy, new HashMap());
        }
        for (int index = inputPaths.size() - 1; index >= 0; --index) {
            File inputPath = inputPaths.get(index);
            String prefix = this.getIndexAsPrefix(index, inputPaths.size());
            _log.info("reading input: " + inputPath);
            GtfsReader reader = new GtfsReader();
            reader.setInputLocation(inputPath);
            GtfsRelationalDaoImpl dao = new GtfsRelationalDaoImpl();
            dao.setPackShapePoints(true);
            dao.setPackStopTimes(true);
            reader.setEntityStore(dao);
            reader.run();
            for (EntityMergeStrategy strategy : strategies) {
                _log.info("strategy=" + strategy.getClass());
                GtfsMergeContext context = new GtfsMergeContext(dao, mergedDao, prefix, (Map)rawEntityIdMapsByMergeStrategy.get(strategy));
                strategy.merge(context);
            }
        }
        _log.info("writing merged output: " + outputPath);
        GtfsWriter writer = new GtfsWriter();
        writer.setOutputLocation(outputPath);
        writer.run(mergedDao);
    }

    private String getIndexAsPrefix(int index, int total) {
        if (total <= _alphaPrefix.length()) {
            return Character.toString(_alphaPrefix.charAt(index)) + "-";
        }
        return _numberPrefixFormat.format(index) + "-";
    }

    private void buildStrategies(List<EntityMergeStrategy> strategies) {
        strategies.add(this._agencyStrategy);
        strategies.add(this._stopStrategy);
        strategies.add(this._serviceCalendarStrategy);
        strategies.add(this._routeStrategy);
        strategies.add(this._tripStrategy);
        strategies.add(this._shapePointStrategy);
        strategies.add(this._frequencyStrategy);
        strategies.add(this._transferStrategy);
        strategies.add(this._fareAttributeStrategy);
        strategies.add(this._fareRuleStrategy);
    }
}

