/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.model.calendar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;

public class ServiceIdIntervals
implements Serializable,
Iterable<Map.Entry<LocalizedServiceId, ServiceInterval>> {
    private static final long serialVersionUID = 1L;
    private Map<LocalizedServiceId, ServiceInterval> _intervals = new HashMap<LocalizedServiceId, ServiceInterval>();

    public void addStopTime(LocalizedServiceId serviceId, int arrivalTime, int departureTime) {
        ServiceInterval interval = this._intervals.get(serviceId);
        interval = interval == null ? new ServiceInterval(arrivalTime, departureTime) : interval.extend(arrivalTime, departureTime);
        this._intervals.put(serviceId, interval);
    }

    public void addIntervals(ServiceIdIntervals intervals) {
        for (Map.Entry<LocalizedServiceId, ServiceInterval> entry : intervals) {
            LocalizedServiceId serviceId = entry.getKey();
            ServiceInterval interval = entry.getValue();
            this.addStopTime(serviceId, interval.getMinArrival(), interval.getMinDeparture());
            this.addStopTime(serviceId, interval.getMaxArrival(), interval.getMaxDeparture());
        }
    }

    public Set<LocalizedServiceId> getServiceIds() {
        return this._intervals.keySet();
    }

    public ServiceInterval getIntervalForServiceId(LocalizedServiceId serviceId) {
        return this._intervals.get(serviceId);
    }

    @Override
    public Iterator<Map.Entry<LocalizedServiceId, ServiceInterval>> iterator() {
        return this._intervals.entrySet().iterator();
    }
}

