/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.gtfs.impl;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ShapePoint;
import org.onebusaway.gtfs.model.ShapePointProxy;

public class ShapePointArray
extends AbstractList<ShapePoint> {
    private int size = 0;
    private AgencyAndId[] shapeIds = new AgencyAndId[0];
    private int[] sequences = new int[0];
    private double[] lats = new double[0];
    private double[] lons = new double[0];
    private double[] distTraveled = new double[0];

    public void trimToSize() {
        this.setLength(this.size);
    }

    @Override
    public boolean add(ShapePoint shapePoint) {
        int index = this.size++;
        this.ensureCapacity(this.size);
        this.shapeIds[index] = shapePoint.getShapeId();
        this.sequences[index] = shapePoint.getSequence();
        this.lats[index] = shapePoint.getLat();
        this.lons[index] = shapePoint.getLon();
        this.distTraveled[index] = shapePoint.getDistTraveled();
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.setLength(0);
    }

    @Override
    public Iterator<ShapePoint> iterator() {
        return new ShapePointIterator();
    }

    @Override
    public ShapePoint get(int index) {
        if (index < 0 || index >= this.size) {
            throw new NoSuchElementException();
        }
        ShapePoint shapePoint = new ShapePoint();
        shapePoint.setProxy(new ShapePointProxyImpl(index));
        return shapePoint;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void ensureCapacity(int capacity) {
        if (this.shapeIds.length < capacity) {
            int newLength = Math.max(8, this.shapeIds.length << 2);
            this.setLength(newLength);
        }
    }

    private void setLength(int newLength) {
        this.shapeIds = Arrays.copyOf(this.shapeIds, newLength);
        this.sequences = Arrays.copyOf(this.sequences, newLength);
        this.lats = Arrays.copyOf(this.lats, newLength);
        this.lons = Arrays.copyOf(this.lons, newLength);
        this.distTraveled = Arrays.copyOf(this.distTraveled, newLength);
    }

    private class ShapePointProxyImpl
    implements ShapePointProxy {
        private final int index;

        public ShapePointProxyImpl(int index) {
            this.index = index;
        }

        @Override
        public Integer getId() {
            return this.index;
        }

        @Override
        public void setId(Integer id) {
        }

        @Override
        public AgencyAndId getShapeId() {
            return ShapePointArray.this.shapeIds[this.index];
        }

        @Override
        public void setShapeId(AgencyAndId shapeId) {
            ((ShapePointArray)ShapePointArray.this).shapeIds[this.index] = shapeId;
        }

        @Override
        public int getSequence() {
            return ShapePointArray.this.sequences[this.index];
        }

        @Override
        public void setSequence(int sequence) {
            ((ShapePointArray)ShapePointArray.this).sequences[this.index] = sequence;
        }

        @Override
        public boolean isDistTraveledSet() {
            return ShapePointArray.this.distTraveled[this.index] != -999.0;
        }

        @Override
        public double getDistTraveled() {
            return ShapePointArray.this.distTraveled[this.index];
        }

        @Override
        public void setDistTraveled(double distTraveled) {
            ((ShapePointArray)ShapePointArray.this).distTraveled[this.index] = distTraveled;
        }

        @Override
        public void clearDistTraveled() {
            ((ShapePointArray)ShapePointArray.this).distTraveled[this.index] = -999.0;
        }

        @Override
        public double getLat() {
            return ShapePointArray.this.lats[this.index];
        }

        @Override
        public void setLat(double lat) {
            ((ShapePointArray)ShapePointArray.this).lats[this.index] = lat;
        }

        @Override
        public double getLon() {
            return ShapePointArray.this.lons[this.index];
        }

        @Override
        public void setLon(double lon) {
            ((ShapePointArray)ShapePointArray.this).lons[this.index] = lon;
        }
    }

    private class ShapePointIterator
    implements Iterator<ShapePoint> {
        private int index = 0;

        private ShapePointIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ShapePointArray.this.size;
        }

        @Override
        public ShapePoint next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ShapePoint shapePoint = new ShapePoint();
            shapePoint.setProxy(new ShapePointProxyImpl(this.index));
            ++this.index;
            return shapePoint;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

