/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.util.Map;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.exceptions.CsvException;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.DefaultFieldMapping;
import org.onebusaway.csv_entities.schema.EntitySchemaFactory;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.onebusaway.csv_entities.schema.FieldMappingFactory;

public class EnumFieldMappingFactory
implements FieldMappingFactory {
    @Override
    public FieldMapping createFieldMapping(EntitySchemaFactory schemaFactory, Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
        if (!objFieldType.isEnum()) {
            throw new CsvException("expected enum type but found " + objFieldType);
        }
        return new FieldMappingImpl(entityType, csvFieldName, objFieldName, objFieldType, required);
    }

    private class FieldMappingImpl
    extends DefaultFieldMapping {
        public FieldMappingImpl(Class<?> entityType, String csvFieldName, String objFieldName, Class<?> objFieldType, boolean required) {
            super(entityType, csvFieldName, objFieldName, objFieldType, required);
        }

        @Override
        public void translateFromCSVToObject(CsvEntityContext context, Map<String, Object> csvValues, BeanWrapper object) {
            Class objFieldType = this._objFieldType;
            if (this.isMissingAndOptional(csvValues)) {
                return;
            }
            String value = csvValues.get(this._csvFieldName).toString();
            Object v = Enum.valueOf(objFieldType, value);
            object.setPropertyValue(this._objFieldName, v);
        }
    }
}

