/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities.schema;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.onebusaway.csv_entities.exceptions.MethodInvocationException;
import org.onebusaway.csv_entities.exceptions.MissingRequiredFieldException;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.SingleFieldMapping;

public abstract class AbstractFieldMapping
implements SingleFieldMapping {
    protected final Class<?> _entityType;
    protected final String _csvFieldName;
    protected final String _objFieldName;
    protected final boolean _required;
    protected int _order = Integer.MAX_VALUE;
    protected boolean _alwaysIncludeInOutput = false;
    protected String _defaultValue = null;
    protected Method _isSetMethod = null;

    public AbstractFieldMapping(Class<?> entityType, String csvFieldName, String objFieldName, boolean required) {
        this._entityType = entityType;
        this._csvFieldName = csvFieldName;
        this._objFieldName = objFieldName;
        this._required = required;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public void setAlwaysIncludeInOutput(boolean alwaysIncludeInOutput) {
        this._alwaysIncludeInOutput = alwaysIncludeInOutput;
    }

    public void setIsSetMethod(Method isSetMethod) {
        this._isSetMethod = isSetMethod;
    }

    @Override
    public String getCsvFieldName() {
        return this._csvFieldName;
    }

    @Override
    public String getObjFieldName() {
        return this._objFieldName;
    }

    @Override
    public void getCSVFieldNames(Collection<String> names) {
        names.add(this._csvFieldName);
    }

    @Override
    public int getOrder() {
        return this._order;
    }

    @Override
    public boolean isMissingAndOptional(Map<String, Object> csvValues) {
        boolean missing = this.isMissing(csvValues);
        if (this._required && missing) {
            throw new MissingRequiredFieldException(this._entityType, this._csvFieldName);
        }
        return missing;
    }

    @Override
    public boolean isMissingAndOptional(BeanWrapper object) {
        boolean missing = this.isMissing(object);
        if (this._required && missing) {
            throw new MissingRequiredFieldException(this._entityType, this._objFieldName);
        }
        return missing;
    }

    @Override
    public boolean isAlwaysIncludeInOutput() {
        return this._alwaysIncludeInOutput;
    }

    protected boolean isMissing(Map<String, Object> csvValues) {
        return !csvValues.containsKey(this._csvFieldName) || csvValues.get(this._csvFieldName).toString().length() <= 0;
    }

    protected boolean isMissing(BeanWrapper object) {
        block6: {
            if (this._isSetMethod != null) {
                Object instance = object.getWrappedInstance(Object.class);
                try {
                    Object r = this._isSetMethod.invoke(instance, new Object[0]);
                    if (r != null && r instanceof Boolean) {
                        Boolean b = (Boolean)r;
                        return b == false;
                    }
                    break block6;
                }
                catch (Exception ex) {
                    throw new MethodInvocationException(this._entityType, this._isSetMethod, ex);
                }
            }
            Object obj = object.getPropertyValue(this._objFieldName);
            if (obj == null) {
                return true;
            }
            if (this._defaultValue != null && !this._defaultValue.isEmpty()) {
                return this._defaultValue.equals(obj.toString());
            }
            return obj instanceof String && obj.toString().isEmpty();
        }
        return false;
    }

    protected boolean isOptional() {
        return !this._required;
    }
}

