/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.util.HashMap;
import java.util.List;
import org.onebusaway.csv_entities.CSVListener;
import org.onebusaway.csv_entities.CsvEntityContext;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.csv_entities.exceptions.EntityInstantiationException;
import org.onebusaway.csv_entities.schema.BeanWrapper;
import org.onebusaway.csv_entities.schema.BeanWrapperFactory;
import org.onebusaway.csv_entities.schema.EntitySchema;
import org.onebusaway.csv_entities.schema.EntityValidator;
import org.onebusaway.csv_entities.schema.FieldMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndividualCsvEntityReader
implements CSVListener {
    private static Logger _log = LoggerFactory.getLogger(IndividualCsvEntityReader.class);
    private EntityHandler _handler;
    private CsvEntityContext _context;
    private EntitySchema _schema;
    private boolean _initialized = false;
    private List<String> _fields;
    private int _line = 1;
    private boolean _verbose = false;
    private boolean _trimValues = false;

    public IndividualCsvEntityReader(CsvEntityContext context, EntitySchema schema, EntityHandler handler) {
        this._handler = handler;
        this._context = context;
        this._schema = schema;
        List<String> inOrder = this._schema.getFieldsInOrder();
        if (!inOrder.isEmpty()) {
            this._initialized = true;
            this._fields = inOrder;
        }
    }

    public IndividualCsvEntityReader(EntityHandler handler, CsvEntityContext context, EntitySchema schema, List<String> fields) {
        this(context, schema, handler);
        this._initialized = true;
        this._fields = fields;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public void setTrimValues(boolean trimValues) {
        this._trimValues = trimValues;
    }

    @Override
    public void handleLine(List<String> line) throws Exception {
        if (line.size() == 0) {
            return;
        }
        if (this._trimValues) {
            for (int i = 0; i < line.size(); ++i) {
                line.set(i, line.get(i).trim());
            }
        }
        if (!this._initialized) {
            this.readSchema(line);
            this._initialized = true;
        } else {
            this.readEntity(line);
        }
        ++this._line;
        if (this._verbose && this._line % 1000 == 0) {
            System.out.println("entities=" + this._line);
        }
    }

    private void readSchema(List<String> line) {
        this._fields = line;
    }

    private void readEntity(List<String> line) {
        if (line.size() != this._fields.size()) {
            _log.warn("expected and actual number of csv fields differ: type=" + this._schema.getEntityClass().getName() + " line # " + this._line + " expected=" + this._fields.size() + " actual=" + line.size());
            while (line.size() < this._fields.size()) {
                line.add("");
            }
        }
        Object object = this.createNewEntityInstance();
        BeanWrapper wrapper = BeanWrapperFactory.wrap(object);
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 0; i < line.size(); ++i) {
            String csvFieldName = this._fields.get(i);
            String value = line.get(i);
            values.put(csvFieldName, value);
        }
        for (FieldMapping mapping : this._schema.getFields()) {
            mapping.translateFromCSVToObject(this._context, values, wrapper);
        }
        for (EntityValidator validator : this._schema.getValidators()) {
            validator.validateEntity(this._context, values, wrapper);
        }
        this._handler.handleEntity(object);
    }

    private Object createNewEntityInstance() {
        Class<?> entityClass = this._schema.getEntityClass();
        try {
            return entityClass.newInstance();
        }
        catch (Exception ex) {
            throw new EntityInstantiationException(entityClass, (Throwable)ex);
        }
    }
}

