/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections.adapter;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.onebusaway.collections.adapter.AdapterLibrary;
import org.onebusaway.collections.adapter.IAdapter;
import org.onebusaway.collections.adapter.MapEntryValueAdapter;

class AdaptableValueSortedMap<KEY, FROM_VALUE, TO_VALUE>
implements SortedMap<KEY, TO_VALUE> {
    private final SortedMap<KEY, FROM_VALUE> _source;
    private final IAdapter<FROM_VALUE, TO_VALUE> _adapter;

    public AdaptableValueSortedMap(SortedMap<KEY, FROM_VALUE> source, IAdapter<FROM_VALUE, TO_VALUE> adapter) {
        this._source = source;
        this._adapter = adapter;
    }

    @Override
    public int size() {
        return this._source.size();
    }

    @Override
    public boolean isEmpty() {
        return this._source.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._source.containsKey(key);
    }

    @Override
    public TO_VALUE get(Object key) {
        return this.adapt(this._source.get(key));
    }

    @Override
    public TO_VALUE remove(Object key) {
        return this.adapt(this._source.remove(key));
    }

    @Override
    public void clear() {
        this._source.clear();
    }

    @Override
    public Comparator<? super KEY> comparator() {
        return this._source.comparator();
    }

    @Override
    public SortedMap<KEY, TO_VALUE> subMap(KEY fromKey, KEY toKey) {
        return new AdaptableValueSortedMap<KEY, FROM_VALUE, TO_VALUE>(this._source.subMap(fromKey, toKey), this._adapter);
    }

    @Override
    public SortedMap<KEY, TO_VALUE> headMap(KEY toKey) {
        return new AdaptableValueSortedMap<KEY, FROM_VALUE, TO_VALUE>(this._source.headMap(toKey), this._adapter);
    }

    @Override
    public SortedMap<KEY, TO_VALUE> tailMap(KEY fromKey) {
        return new AdaptableValueSortedMap<KEY, FROM_VALUE, TO_VALUE>(this._source.tailMap(fromKey), this._adapter);
    }

    @Override
    public KEY firstKey() {
        return this._source.firstKey();
    }

    @Override
    public KEY lastKey() {
        return this._source.lastKey();
    }

    @Override
    public Set<KEY> keySet() {
        return this._source.keySet();
    }

    @Override
    public Collection<TO_VALUE> values() {
        return AdapterLibrary.adaptCollection(this._source.values(), this._adapter);
    }

    @Override
    public Set<Map.Entry<KEY, TO_VALUE>> entrySet() {
        return AdapterLibrary.adaptSet(this._source.entrySet(), new MapEntryValueAdapter(this._adapter));
    }

    @Override
    public TO_VALUE put(KEY key, TO_VALUE value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends TO_VALUE> m) {
        throw new UnsupportedOperationException();
    }

    private TO_VALUE adapt(FROM_VALUE value) {
        if (value == null) {
            return null;
        }
        return this._adapter.adapt(value);
    }
}

