/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Counter<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<T, Integer> _counts = new HashMap<T, Integer>();
    private int _total = 0;

    public int size() {
        return this._counts.size();
    }

    public void increment(T key, int offset) {
        int count = this.getCount(key) + offset;
        this._counts.put(key, count);
        this._total += offset;
    }

    public void increment(T key) {
        this.increment(key, 1);
    }

    public void decrement(T key) {
        this.increment(key, -1);
    }

    public int getCount(T key) {
        Integer count = this._counts.get(key);
        if (count == null) {
            count = 0;
        }
        return count;
    }

    public Set<T> getKeys() {
        return this._counts.keySet();
    }

    public Set<Map.Entry<T, Integer>> getEntrySet() {
        return this._counts.entrySet();
    }

    public int getTotal() {
        return this._total;
    }

    public T getMax() {
        int maxCount = 0;
        T maxValue = null;
        for (Map.Entry<T, Integer> entry : this._counts.entrySet()) {
            if (maxValue != null && maxCount >= entry.getValue()) continue;
            maxValue = entry.getKey();
            maxCount = entry.getValue();
        }
        return maxValue;
    }

    public List<T> getSortedKeys() {
        ArrayList<T> values = new ArrayList<T>(this._counts.keySet());
        Collections.sort(values, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int b;
                int a = Counter.this.getCount(o1);
                if (a == (b = Counter.this.getCount(o2))) {
                    return 0;
                }
                return a < b ? -1 : 1;
            }
        });
        return values;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Counter)) {
            return false;
        }
        Counter c = (Counter)obj;
        return ((Object)this._counts).equals(c._counts);
    }

    public int hashCode() {
        return ((Object)this._counts).hashCode();
    }

    public String toString() {
        return this._counts.toString();
    }
}

