/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentCollectionsLibrary {
    private static final ListFactory _listFactory = new ListFactory();
    private static final SetFactory _setFactory = new SetFactory();

    public static <KEY, VALUE> void addToMapValueList(ConcurrentMap<KEY, List<VALUE>> map, KEY key, VALUE value) {
        CollectionFactory<VALUE, List<VALUE>> factory = ConcurrentCollectionsLibrary.listFactory();
        ConcurrentCollectionsLibrary.addToMapValueCollection(map, key, value, factory);
    }

    public static <KEY, VALUE> void removeFromMapValueList(ConcurrentMap<KEY, List<VALUE>> map, KEY key, VALUE value) {
        CollectionFactory<VALUE, List<VALUE>> factory = ConcurrentCollectionsLibrary.listFactory();
        ConcurrentCollectionsLibrary.removeFromMapValueCollection(map, key, value, factory);
    }

    public static <KEY, VALUE> void addToMapValueSet(ConcurrentMap<KEY, Set<VALUE>> map, KEY key, VALUE value) {
        CollectionFactory<VALUE, Set<VALUE>> factory = ConcurrentCollectionsLibrary.setFactory();
        ConcurrentCollectionsLibrary.addToMapValueCollection(map, key, value, factory);
    }

    public static <KEY, VALUE> void removeFromMapValueSet(ConcurrentMap<KEY, Set<VALUE>> map, KEY key, VALUE value) {
        CollectionFactory<VALUE, Set<VALUE>> factory = ConcurrentCollectionsLibrary.setFactory();
        ConcurrentCollectionsLibrary.removeFromMapValueCollection(map, key, value, factory);
    }

    private static <KEY, VALUE, C extends Collection<VALUE>> void addToMapValueCollection(ConcurrentMap<KEY, C> map, KEY key, VALUE value, CollectionFactory<VALUE, C> factory) {
        Collection extendedCopy;
        Collection origCopy;
        do {
            C newKeys;
            Collection values;
            if ((values = (Collection)map.get(key)) == null && (values = (Collection)map.putIfAbsent(key, newKeys = factory.create(value))) == null) {
                return;
            }
            origCopy = factory.copy(values);
            if (origCopy.contains(value)) {
                return;
            }
            extendedCopy = factory.copy(origCopy);
            extendedCopy.add(value);
        } while (!map.replace(key, origCopy, extendedCopy));
    }

    private static <KEY, VALUE, C extends Collection<VALUE>> void removeFromMapValueCollection(ConcurrentMap<KEY, C> map, KEY key, VALUE value, CollectionFactory<VALUE, C> factory) {
        Collection origCopy;
        Collection reducedCopy;
        do {
            Collection values;
            if ((values = (Collection)map.get(key)) == null) {
                return;
            }
            origCopy = factory.copy(values);
            if (!origCopy.contains(value)) {
                return;
            }
            reducedCopy = factory.copy(origCopy);
            reducedCopy.remove(value);
        } while (!(reducedCopy.isEmpty() ? map.remove(key, origCopy) : map.replace(key, origCopy, reducedCopy)));
    }

    private static <VALUE> CollectionFactory<VALUE, List<VALUE>> listFactory() {
        return _listFactory;
    }

    private static <VALUE> CollectionFactory<VALUE, Set<VALUE>> setFactory() {
        return _setFactory;
    }

    private static class SetFactory
    implements CollectionFactory {
        private SetFactory() {
        }

        public Collection create(Object value) {
            HashSet<Object> values = new HashSet<Object>();
            values.add(value);
            return values;
        }

        public Collection copy(Collection existingValues) {
            return new HashSet(existingValues);
        }
    }

    private static class ListFactory
    implements CollectionFactory {
        private ListFactory() {
        }

        public Collection create(Object value) {
            ArrayList<Object> values = new ArrayList<Object>(1);
            values.add(value);
            return values;
        }

        public Collection copy(Collection existingValues) {
            return new ArrayList(existingValues);
        }
    }

    private static interface CollectionFactory<VALUE, C extends Collection<VALUE>> {
        public C create(VALUE var1);

        public C copy(C var1);
    }
}

